clear all; clear all; clc

global  a_1 b_1 c_1 d_1 e_1 f_1 g_1 h_1 a_2 b_2 c_2 d_2 e_2 f_2 g_2 h_2 a_3 b_3 c_3 d_3 e_3 f_3 g_3 h_3...
        d1_1 e1_1 f1_1 g1_1 c2_1 d2_1 e2_1 f2_1 g2_1 b3_1 c3_1 d3_1 e3_1 f3_1 g3_1...
        d1_2 e1_2 f1_2 g1_2 c2_2 d2_2 e2_2 f2_2 g2_2 b3_2 c3_2 d3_2 e3_2 f3_2 g3_2...
        d1_3 e1_3 f1_3 g1_3 c2_3 d2_3 e2_3 f2_3 g2_3 b3_3 c3_3 d3_3 e3_3 f3_3 g3_3...
        Pn_1 Pn_2 Pn_3 m_load_1 m_load_2 m_load_3  Material_E J_1 J_2 J_3 dJ_1 dJ_2 dJ_3 d2J_1 d2J_2 d2J_3...
        ds_1 ds_2 ds_3  s_1 s_2 s_3 R_s_1 R_s_2 R_s_3 dR_s_1 dR_s_2 dR_s_3 d2R_s_1 d2R_s_2 d2R_s_3 d3R_s_1 d3R_s_2 d3R_s_3 d4R_s_1 d4R_s_2 d4R_s_3 s_1_exp s_2_exp s_3_exp...
        k_el k_el_1 NP_1 NP_2 NP_3 HP1 HP2 HP3 AL x_s_1...
        aM_1 bM_1 cM_1 dM_1 aM_2 bM_2 cM_2 dM_2 aM_3 bM_3 cM_3 dM_3...
        aT_1 bT_1 cT_1 dT_1 eT_1 aT_2 bT_2 cT_2 dT_2 eT_2 aT_3 bT_3 cT_3 dT_3 eT_3...
        aN_1 bN_1 cN_1 dN_1 eN_1 fN_1 aN_2 bN_2 cN_2 dN_2 eN_2 fN_2 aN_3 bN_3 cN_3 dN_3 eN_3 fN_3

%% %% Arch Analysis


%% Input parameters
Arch.f = 30;                        % Height of the arch [m]
Arch.L = 100;                       % Span length [m]
Arch.Lhalf = Arch.L/2;
AL = Arch.L;
n = 50;
NP = n+1;
n_1 = 7;                          % Number of intervals of the mesh [/]
n_3 = 36;
n_2 = 7;
q0 = -262;                         % Uniformly distributed load [kN/m]
NP_1 = n_1+1;                     % Number of points of the mesh [/]
NP_2 = n_2+1;                     % Number of points of the mesh [/]
NP_3 = n_3+1;
HP1 = NP_1 + 6;
HP2 = HP1 + NP_3 + 6;
HP3 = HP2 + NP_2 + 6;


%% Material
Material.gamma = 78.5;       % Specific weight [kN/m3]
Material.E = 2.1*10^8;        % Young modulus [kN/m2]
Material_E = Material.E;
Material.nu = 0.3;                     % Poisson ratio [-]
Material.G = (Material.E)/(2*(Material.nu+1));        % Shear modulus [kN/m2]
Material.fyd = 355;          % Design strength [MPa]

Section.r_base = 0.500;                   % Sectional 1st dimension at the arc base[m]
Section.r = 0.5*Section.r_base;                       % Reduction factor
Section.r_base2 = 0.5;                % Sectional 2nd dimension at the arc base[m]
Section.t = 0.05;                       % Thickness of hollowed sections [m]
ratio = Section.r_base2/Section.r_base;     % Ratio between the section dimensions

%% User choices
Arch.curve = input("Insert the selected curve type:\n Parabolic = 1\n Circular = 2\n4th order polybomial = 3\n");
Section.variation = input("Insert the type of variation of the section dimension:\n Constant = 1\n Linear = 2\n Quadratic = 3\n");
Section.type = input("Insert the selected section type:\n Circular = 1\n Ellipsoidal = 2\n Squared = 3\n Rectangular = 4\n Hollowed circle = 5\n Hollowed square = 6\n Hollowed rectangle = 7\nInsert the correspondent number:\n");
Restraint = input("Insert the selected restraint condition = \n Fully restrained arch = 1\n Hinged arch = 2\n");

tic

%% Curve

syms X

if Arch.curve == 1
    % Parabola
    y = (-4*Arch.f/(Arch.L^2))*(X^2) + Arch.f;              % Parabola equation
elseif Arch.curve ==2
    % Circumference
    y = sqrt(-X^2-(-(Arch.L^2)/4)+(((Arch.L^2)/(4*Arch.f)-Arch.f)^2)/4)-((Arch.L^2)/(4*Arch.f)-Arch.f)/2;    % Circumference equation
elseif Arch.curve ==3
    m = 4.0*Arch.f/Arch.L;
    y = (-4*m/(Arch.L^3) + 16*Arch.f/(Arch.L^4))*X^4 + (m/Arch.L - 8*Arch.f/(Arch.L^2))*X^2 + Arch.f;                          % 4-th order polynomial
end


% Derive the curve
dy = diff(y,X);                 % 1st derivative of the parabola
d2y = diff(dy,X);               % 2nd derivative of the parabola


% Calculation of the incremental intervals
x_inter = [-Arch.L/2 -Arch.L/2 + linspace(1,n,n).*Arch.L/n];
y_inter = [0 double(subs(y,X,x_inter(2:n+1)))];
dy_inter = y_inter(2:n+1) - y_inter(1:n);

% Allocation of memory space for variables (fastening the calculation)
s_x = zeros(1,n+1);           % Curvilinear coordinates

% Calculation of s(x)
for i = 1:n
    s_x(i+1) = s_x(i) + sqrt((Arch.L/n)^2 + dy_inter(i)^2);
end

%% Equispaced nodes along s
ds = s_x(end)/n;
s = ds.*(linspace(0,n,n+1));
s_exp = [-3*ds -2*ds -1*ds s s(end)+ds s(end)+2*ds s(end)+3*ds];
x_s = interp1(s_x,x_inter,s,'pchip','extrap');

x_s_0 = x_s(1);
y_s_0 = interp1(x_inter, y_inter,x_s(1),'pchip','extrap');
x_s_0 = x_s_0+Arch.Lhalf;

x_s_8 = x_s(8);
y_s_8 = interp1(x_inter, y_inter, x_s(8),'pchip','extrap');
x_s_8 = x_s_8+Arch.Lhalf;

x_s_44 = x_s(44);
y_s_44 = interp1(x_inter,y_inter,x_s(44),'pchip','extrap');
x_s_44 = x_s_44+Arch.Lhalf;

Arch.L1 = (x_s_8);
Arch.L3 = Arch.L - (x_s_8 + (Arch.L - x_s_44));
Arch.L2 = (Arch.L - x_s_44);

%% Curve 1

syms X_1

if Arch.curve == 1
% Parabola equation
gamma11 = x_s_0 ;              gamma21 = x_s_0 + Arch.Lhalf ; gamma31 = x_s_0 + Arch.L;  %punti per cui passa la parabola 1
beta11 = y_s_0 ;               beta21 = Arch.f;               beta31 = 0;                      

    numa_1 = gamma11 * (beta21-beta31) + gamma21*(beta31 - beta11) + gamma31*(beta11 - beta21);
    numb_1 = gamma11^2*(beta21-beta31) + gamma21^2*(beta31-beta11) + gamma31^2*(beta11-beta21);
    numc_1 = gamma11^2*(gamma21*beta31 - gamma31*beta21) + gamma11*((gamma31^2)*beta21 - (gamma21^2)*beta31) + (gamma21*gamma31*beta11*(gamma21 - gamma31));

    den_1 = (gamma11-gamma21)*(gamma11-gamma31)*(gamma31-gamma21);

    Ap_1 = numa_1/den_1; Bp_1 = -numb_1/den_1; Cp_1 = -numc_1/den_1;

    y_1 = Ap_1.*X_1^2 + Bp_1.*X_1 +Cp_1;          % Parabola equation

elseif Arch.curve ==2
    % Circumference
    coeffA_1 = -Arch.L;
    coeffB_1 = ((Arch.L^2)/(4*Arch.f)) - Arch.f;
    coeffC_1 = 0;
    y_1 = sqrt(-X_1^2-(coeffA_1*X_1)-coeffC_1+((coeffB_1^2)/4)) - coeffB_1/2;  % Circumference equation
elseif Arch.curve == 3
    m = 4.0*Arch.f/Arch.L;
    y_1 = (-4*m/(Arch.L^3) + 16*Arch.f/(Arch.L^4))*X_1^4 + (m/Arch.L - 8*Arch.f/(Arch.L^2))*X_1^2 + Arch.f;                          % 4-th order polynomial
end


% Derive the curve
dy_1 = diff(y_1,X_1);                 % 1st derivative of the parabola
d2y_1 = diff(dy_1,X_1);               % 2nd derivative of the parabola

%% Curve 2

syms X_2

if Arch.curve == 1
    % Parabola equation
    gamma12 = -x_s_44 ;       gamma22 = Arch.L-x_s_44;      gamma32 = -(x_s_44 - Arch.Lhalf) ; %punti per cui passa la parabola 2
    beta12 = -y_s_8;          beta22 = -y_s_44;              beta32 = Arch.f-y_s_44;                         
    

    numa_2 = gamma12 * (beta22-beta32) + gamma22*(beta32 - beta12) + gamma32*(beta12 - beta22);
    numb_2 = gamma12^2*(beta22-beta32) + gamma22^2*(beta32-beta12) + gamma32^2*(beta12-beta22);
    numc_2 = gamma12^2*(gamma22*beta32 - gamma32*beta22) + gamma12*((gamma32^2)*beta22 - (gamma22^2)*beta32) + (gamma22*gamma32*beta12*(gamma22 - gamma32));

    den_2 = (gamma12-gamma22)*(gamma12-gamma32)*(gamma32-gamma22);

    Ap_2 = numa_2/den_2; Bp_2 = -numb_2/den_2; Cp_2 = -numc_2/den_2;

    y_2 = Ap_2.*X_2^2 + Bp_2.*X_2 +Cp_2;          % Parabola equation

elseif Arch.curve ==2
    % Circumference
    coeffA_2 = 0;
    coeffB_2 = ((Arch.L^2)/(4*Arch.f) + Arch.f);
    coeffC_2 = 0;

    y_2 = sqrt(-X_2^2 -(coeffA_2*X_2)-coeffC_2+((coeffB_2^2)/4)) - coeffB_2/2;    % Circumference equation

elseif Arch.curve ==3
    m = 4.0*Arch.f/Arch.L;
    y_2 = (-4*m/(Arch.L^3) + 16*Arch.f/(Arch.L^4))*X_2^4 + (m/Arch.L - 8*Arch.f/(Arch.L^2))*X_2^2 + Arch.f;                          % 4-th order polynomial
end


% Derive the curve
dy_2 = diff(y_2,X_2);                 % 1st derivative of the parabola
d2y_2 = diff(dy_2,X_2);               % 2nd derivative of the parabola

%% Curve 3

syms X_3

if Arch.curve == 1
    %PArabola equation
    gamma13 = 0;                gamma23 = Arch.L - 2*x_s_8;         gamma33= Arch.Lhalf - x_s_8 ; %punti per cui passa la terza parabola
    beta13 = 0;                 beta23= 0;                          beta33= Arch.f-y_s_8; 

    numa_3 = gamma13 * (beta23-beta33) + gamma23*(beta33 - beta13) + gamma33*(beta13 - beta23);
    numb_3 = gamma13^2*(beta23-beta33) + gamma23^2*(beta33-beta13) + gamma33^2*(beta13-beta23);
    numc_3 = gamma13^2*(gamma23*beta33 - gamma33*beta23) + gamma13*((gamma33^2)*beta23 - (gamma23^2)*beta33) + (gamma23*gamma33*beta13*(gamma23 - gamma33));

    den_3 = (gamma13-gamma23)*(gamma13-gamma33)*(gamma33-gamma23);

    Ap_3 = numa_3/den_3; Bp_3 = -numb_3/den_3; Cp_3 = -numc_3/den_3;

    y_3 = Ap_3.*X_3^2 + Bp_3.*X_3 +Cp_3;        % Parabola equation

elseif Arch.curve ==2
    % Circumference
    coeffA_3 = -Arch.L;
    coeffB_3 = ((Arch.L^2)/(4*Arch.f)) - Arch.f;
    coeffC_3 = 0;
    y_3 = sqrt(-X_3^2-(coeffA_3*X_3)-coeffC_3+((coeffB_3^2)/4)) - coeffB_3/2;  % Circumference equation
elseif Arch.curve ==3
    m = 4.0*Arch.f/Arch.L;
    y_3 = (-4*m/(Arch.L^3) + 16*Arch.f/(Arch.L^4))*X_3^4 + (m/Arch.L - 8*Arch.f/(Arch.L^2))*X_3^2 + Arch.f;                          % 4-th order polynomial
end


% Derive the curve
dy_3 = diff(y_3,X_3);                 % 1st derivative of the parabola
d2y_3 = diff(dy_3,X_3);               % 2nd derivative of the parabola


%% Calculation of s(x) 1

% Calculation of the incremental intervals
x_1_inter = [0 linspace(1,n_1,n_1).*Arch.L1/n_1];
y_1_inter = [0 double(subs(y_1,X_1,x_1_inter(2:n_1+1)))];
dy_1_inter = y_1_inter(2:n_1+1) - y_1_inter(1:n_1);

% Allocation of memory space for variables (fastening the calculation)
s_x_1 = zeros(1,n_1+1);           % Curvilinear coordinates

% Calculation of s(x)
for i = 1:n_1
    s_x_1(i+1) = s_x_1(i) + sqrt((Arch.L1/n_1)^2 + dy_1_inter(i)^2);
end

%% Calculation of s(x) 2

% Calculation of the incremental intervals
x_2_inter = [0 linspace(1,n_2,n_2).*Arch.L2/n_2];
y_2_inter = [0 double(subs(y_2,X_2,x_2_inter(2:n_2+1)))];
dy_2_inter = y_2_inter(2:n_2+1) - y_2_inter(1:n_2);

% Allocation of memory space for variables (fastening the calculation)
s_x_2 = zeros(1,n_2+1);           % Curvilinear coordinates

% Calculation of s(x)
for i = 1:n_2
    s_x_2(i+1) = s_x_2(i) + sqrt((Arch.L2/n_2)^2 + dy_2_inter(i)^2);
end

%% Calculation of s(x) 3

% Calculation of the incremental intervals
x_3_inter = [0 linspace(1,n_3,n_3).*Arch.L3/n_3];
y_3_inter = [0 double(subs(y_3,X_3,x_3_inter(2:n_3+1)))];
dy_3_inter = y_3_inter(2:n_3+1) - y_3_inter(1:n_3);

% Allocation of memory space for variables (fastening the calculation)
s_x_3 = zeros(1,n_3+1);           % Curvilinear coordinates

% Calculation of s(x)
for i = 1:n_3
    s_x_3(i+1) = s_x_3(i) + sqrt((Arch.L3/n_3)^2 + dy_3_inter(i)^2);
end
%% Equispaced nodes along s 1
ds_1 = s_x_1(end)/n_1;
s_1 = ds_1.*(linspace(0,n_1,n_1+1));
s_1_exp = [-3*ds_1 -2*ds_1 -1*ds_1 s_1 s_1(end)+ds_1 s_1(end)+2*ds_1 s_1(end)+3*ds_1];
x_s_1 = interp1(s_x_1,x_1_inter,s_1,'pchip','extrap');

%% Equispaced nodes along s 2
ds_2 = s_x_2(end)/n_2;
s_2 = ds_2.*(linspace(0,n_2,n_2+1));
s_2_exp = [-3*ds_2 -2*ds_2 -1*ds_2 s_2 s_2(end)+ds_2 s_2(end)+2*ds_2 s_2(end)+3*ds_2];
x_s_2 = interp1(s_x_2,x_2_inter,s_2,'pchip','extrap');

%% Equispaced nodes along s 3
ds_3 = s_x_3(end)/n_3;
s_3 = ds_3.*(linspace(0,n_3,n_3+1));
s_3_exp = [-3*ds_3 -2*ds_3 -1*ds_3 s_3 s_3(end)+ds_3 s_3(end)+2*ds_3 s_3(end)+3*ds_3];
x_s_3 = interp1(s_x_3,x_3_inter,s_3,'pchip','extrap');


%% Curvature radius and its derivatives 1

% Mathematical form
R_x_1_math = -((1+(dy_1)^2)^(3/2))/d2y_1;          % R(x)

R_s_1 = double(subs(R_x_1_math,X_1,x_s_1)); % R[s(x)] [m]

% Calculation of the curvature radius and its derivatives(FDM)             
dR_s_1 = interp1(s_1(1:n_1)+ds_1/2,diff(R_s_1)./ds_1,s_1,'pchip','extrap');
d2R_s_1 = interp1(s_1(1:n_1)+ds_1/2,diff(dR_s_1)./ds_1,s_1,'pchip','extrap');
d3R_s_1 = interp1(s_1(1:n_1)+ds_1/2,diff(d2R_s_1)./ds_1,s_1,'pchip','extrap');
d4R_s_1 = interp1(s_1(1:n_1)+ds_1/2,diff(d3R_s_1)./ds_1,s_1,'pchip','extrap');
d5R_s_1 = interp1(s_1(1:n_1)+ds_1/2,diff(d4R_s_1)./ds_1,s_1,'pchip','extrap');

%% Curvature radius and its derivatives 2

% Mathematical form
R_x_2_math = -((1+(dy_2)^2)^(3/2))/d2y_2;          % R(x)

R_s_2 = double(subs(R_x_2_math,X_2,x_s_2)); % R[s(x)] [m]

% Calculation of the curvature radius and its derivatives(FDM)             
dR_s_2 = interp1(s_2(1:n_2)+ds_2/2,diff(R_s_2)./ds_2,s_2,'pchip','extrap');
d2R_s_2 = interp1(s_2(1:n_2)+ds_2/2,diff(dR_s_2)./ds_2,s_2,'pchip','extrap');
d3R_s_2 = interp1(s_2(1:n_2)+ds_2/2,diff(d2R_s_2)./ds_2,s_2,'pchip','extrap');
d4R_s_2 = interp1(s_2(1:n_2)+ds_2/2,diff(d3R_s_2)./ds_2,s_2,'pchip','extrap');
d5R_s_2 = interp1(s_2(1:n_2)+ds_2/2,diff(d4R_s_2)./ds_2,s_2,'pchip','extrap');

%% Curvature radius and its derivatives 3

% Mathematical form
R_x_3_math = -((1+(dy_3)^2)^(3/2))/d2y_3;          % R(x)

R_s_3 = double(subs(R_x_3_math,X_3,x_s_3)); % R[s(x)] [m]

% Calculation of the curvature radius and its derivatives(FDM)             
dR_s_3 = interp1(s_3(1:n_3)+ds_3/2,diff(R_s_3)./ds_3,s_3,'pchip','extrap');
d2R_s_3 = interp1(s_3(1:n_3)+ds_3/2,diff(dR_s_3)./ds_3,s_3,'pchip','extrap');
d3R_s_3 = interp1(s_3(1:n_3)+ds_3/2,diff(d2R_s_3)./ds_3,s_3,'pchip','extrap');
d4R_s_3 = interp1(s_3(1:n_3)+ds_3/2,diff(d3R_s_3)./ds_3,s_3,'pchip','extrap');
d5R_s_3 = interp1(s_3(1:n_3)+ds_3/2,diff(d4R_s_3)./ds_3,s_3,'pchip','extrap');
%% Transversal section properties along s(x)
% Section dimensions
if Section.variation == 1
    r1(1:NP) = Section.r_base;      % Sections radius [m]
elseif Section.variation == 2
    r1 = ((Section.r_base - Section.r)./(s(end)./2)).*abs(s - s(end)./2) + Section.r;   % Sections radius [m] 
elseif Section.variation == 3
    r1 = Section.r_base+(4/s(end))*(Section.r-Section.r_base).*s-(4/(s(end)^2))*(Section.r-Section.r_base).*(s.^2);   % Sections radius [m]
end

if Section.variation == 1
    r2(1:NP) = Section.r_base2;      % Sections radius [m]
else
    r2 = ratio*r1;
end

t = Section.t;          % Thickness of the hollowed section [m]


r1_1 = r1(1:NP_1);
r2_1 = r2(1:NP_1);


%% Transversal section properties along s(x) 1

t_1 = Section.t;          % Thickness of the hollowed section [m]

% Geometrical parameters
if Section.type == 1        % Circular
    J_1 = (pi.*(r1_1.^4))./4;                       % Inertia [m4]
    A_1 = pi.*(r1_1.^2);                            % Section area [m2]
    W_1 = pi.*(r1_1.^4)./(4.*r1_1);                   % Resistant modulus [m3]
elseif Section.type == 2    % Ellipsoidal
    J_1 = (pi.*(r2_1.*r1_1.^3))./4;                   % Inertia [m4]
    A_1 = pi.*(r2_1.*r1_1);                           % Section area [m2]
    W_1 = pi.*(r2_1.*r1_1.^3)./(4.*r2_1);               % Resistant modulus [m3]
elseif Section.type == 3    % Square
    J_1 = (r1_1.^4)./12;                            % Inertia [m4]
    A_1 = r1_1.^2;                                  % Section area [m2]
    W_1 = (r1_1.^3)./6;                             % Resistant modulus [m3]
elseif Section.type == 4    % Rectangular
    J_1 = r2_1.*(r1_1.^3)./12;                        % Inertia [m4]
    A_1 = r2_1.*r1_1;                                 % Section area [m2]
    W_1 = r2_1.*(r1_1.^2)./6;                         % Resistant modulus [m3]
elseif Section.type == 5    % Hollowed circular
    J_1 = (pi.*(r1_1.^4-(r1_1-t_1).^4))./4;             % Inertia [m4]
    A_1 = pi.*(r1_1.^2-(r1_1-t_1).^2);                  % Section area [m2]
    W_1 = (pi.*(r1_1.^4-(r1_1-t_1).^4))./(4.*r1_1);       % Resistant modulus [m3]
elseif Section.type == 6    % Hollowed square
    J_1 =  (r1_1.^4 - (r1_1-2*t_1).^4)./12;               % Inertia [m4]
    A_1 =  r1_1.^2 - ((r1_1-2*t_1).^2);                     % Section area [m2]
    W_1 =  (r1_1.^4 - (r1_1-2*t_1).^4)./(6.*r1_1);          % Resistant modulus [m3]
elseif Section.type == 7    % Hollowed rectangle
    J_1 =  (r2_1.*(r1_1.^3) - (r2_1-2*t_1).*((r1_1-2*t_1).^3))./12;         % Inertia [m4]
    A_1 =  r2_1.*r1_1 - ((r2_1-2*t_1).*(r1_1-2*t_1));                           % Section area [m2]
    W_1 =  (r2_1.*(r1_1.^3) - (r2_1-2*t_1).*((r1_1-2*t_1).^3))./(6.*r1_1);    % Resistant modulus [m3]
end

% Smoothing of the inertia in case of linear variation of r1_1
if Section.variation == 2
    J_1_fit = polyfit(s_1,J_1,4);
    J_1 = polyval(J_1_fit,s_1);
end

% Inertia and its derivatives - mathematical form
dJ_1  = interp1(s_1(1:n_1)+ds_1/2,diff(J_1)./ds_1,s_1,'linear','extrap');
d2J_1 = interp1(s_1(1:n_1)+ds_1/2,diff(dJ_1)./ds_1,s_1,'linear','extrap');
d3J_1 = interp1(s_1(1:n_1)+ds_1/2,diff(d2J_1)./ds_1,s_1,'linear','extrap');

%% Transversal section properties along s(x) 2

t_2 = Section.t;          % Thickness of the hollowed section [m]

r1_2 = r1(NP_1+NP_3-1:NP_1+NP_3+NP_2-2);
r2_2 = r2(NP_1+NP_3-1:NP_1+NP_3+NP_2-2);


% Geometrical parameters
if Section.type == 1        % Circular
    J_2 = (pi.*(r1_2.^4))./4;                       % Inertia [m4]
    A_2 = pi.*(r1_2.^2);                            % Section area [m2]
    W_2 = pi.*(r1_2.^4)./(4.*r1_2);                   % Resistant modulus [m3]
elseif Section.type == 2    % Ellipsoidal
    J_2 = (pi.*(r2_2.*r1_2.^3))./4;                   % Inertia [m4]
    A_2 = pi.*(r2_2.*r1_2);                           % Section area [m2]
    W_2 = pi.*(r2_2.*r1_2.^3)./(4.*r2_2);               % Resistant modulus [m3]
elseif Section.type == 3    % Square
    J_2 = (r1_2.^4)./12;                            % Inertia [m4]
    A_2 = r1_2.^2;                                  % Section area [m2]
    W_2 = (r1_2.^3)./6;                             % Resistant modulus [m3]
elseif Section.type == 4    % Rectangular
    J_2 = r2_2.*(r1_2.^3)./12;                        % Inertia [m4]
    A_2 = r2_2.*r1_2;                                 % Section area [m2]
    W_2 = r2_2.*(r1_2.^2)./6;                         % Resistant modulus [m3]
elseif Section.type == 5    % Hollowed circular
    J_2 = (pi.*(r1_2.^4-(r1_2-t_2).^4))./4;             % Inertia [m4]
    A_2 = pi.*(r1_2.^2-(r1_2-t_2).^2);                  % Section area [m2]
    W_2 = (pi.*(r1_2.^4-(r1_2-t_2).^4))./(4.*r1_2);       % Resistant modulus [m3]
elseif Section.type == 6    % Hollowed square
    J_2 =  (r1_2.^4 - (r1_2-2*t_2).^4)./12;               % Inertia [m4]
    A_2 =  r1_2.^2 - ((r1_2-2*t_2).^2);                     % Section area [m2]
    W_2 =  (r1_2.^4 - (r1_2-2*t_2).^4)./(6.*r1_2);          % Resistant modulus [m3]
elseif Section.type == 7    % Hollowed rectangle
    J_2 =  (r2_2.*(r1_2.^3) - (r2_2-2*t_2).*((r1_2-2*t_2).^3))./12;         % Inertia [m4]
    A_2 =  r2_2.*r1_2 - ((r2_2-2*t_2).*(r1_2-2*t_2));                           % Section area [m2]
    W_2 =  (r2_2.*(r1_2.^3) - (r2_2-2*t_2).*((r1_2-2*t_2).^3))./(6.*r1_2);    % Resistant modulus [m3]
end

% Smoothing of the inertia in case of linear variation of r1_1
if Section.variation == 2
    J_2_fit = polyfit(s_2,J_2,4);
    J_2 = polyval(J_2_fit,s_2);
end

% Inertia and its derivatives - mathematical form
dJ_2 = interp1(s_2(1:n_2)+ds_2/2,diff(J_2)./ds_2,s_2,'linear','extrap');
d2J_2 = interp1(s_2(1:n_2)+ds_2/2,diff(dJ_2)./ds_2,s_2,'linear','extrap');
d3J_2 = interp1(s_2(1:n_2)+ds_2/2,diff(d2J_2)./ds_2,s_2,'linear','extrap');

%% Transversal section properties along s(x) 3

t_3 = Section.t;          % Thickness of the hollowed section [m]

r1_3 = r1(NP_1:NP_3+NP_1-1);
r2_3 = r2(NP_1:NP_3+NP_1-1);

% Geometrical parameters
if Section.type == 1        % Circular
    J_3 = (pi.*(r1_3.^4))./4;                       % Inertia [m4]
    A_3 = pi.*(r1_3.^2);                            % Section area [m2]
    W_3 = pi.*(r1_3.^4)./(4.*r1_3);                   % Resistant modulus [m3]
elseif Section.type == 2    % Ellipsoidal
    J_3 = (pi.*(r2_3.*r1_3.^3))./4;                   % Inertia [m4]
    A_3 = pi.*(r2_3.*r1_3);                           % Section area [m2]
    W_3 = pi.*(r2_3.*r1_3.^3)./(4.*r2_3);               % Resistant modulus [m3]
elseif Section.type == 3    % Square
    J_3 = (r1_3.^4)./12;                            % Inertia [m4]
    A_3 = r1_3.^2;                                  % Section area [m2]
    W_3 = (r1_3.^3)./6;                             % Resistant modulus [m3]
elseif Section.type == 4    % Rectangular
    J_3 = r2_3.*(r1_3.^3)./12;                        % Inertia [m4]
    A_3 = r2_3.*r1_3;                                 % Section area [m2]
    W_3 = r2_3.*(r1_3.^2)./6;                         % Resistant modulus [m3]
elseif Section.type == 5    % Hollowed circular
    J_3 = (pi.*(r1_3.^4-(r1_3-t_3).^4))./4;             % Inertia [m4]
    A_3 = pi.*(r1_3.^2-(r1_3-t_3).^2);                  % Section area [m2]
    W_3 = (pi.*(r1_3.^4-(r1_3-t_3).^4))./(4.*r1_3);       % Resistant modulus [m3]
elseif Section.type == 6    % Hollowed square
    J_3 =  (r1_3.^4 - (r1_3-2*t_3).^4)./12;               % Inertia [m4]
    A_3 =  r1_3.^2 - ((r1_3-2*t_3).^2);                     % Section area [m2]
    W_3 =  (r1_3.^4 - (r1_3-2*t_3).^4)./(6.*r1_3);          % Resistant modulus [m3]
elseif Section.type == 7    % Hollowed rectangle
    J_3 =  (r2_3.*(r1_3.^3) - (r2_3-2*t_3).*((r1_3-2*t_3).^3))./12;         % Inertia [m4]
    A_3 =  r2_3.*r1_3 - ((r2_3-2*t_3).*(r1_3-2*t_3));                           % Section area [m2]
    W_3 =  (r2_3.*(r1_3.^3) - (r2_3-2*t_3).*((r1_3-2*t_3).^3))./(6.*r1_3);    % Resistant modulus [m3]
end

% Smoothing of the inertia in case of linear variation of r1_1
if Section.variation == 2
    J_3_fit = polyfit(s_3,J_3,4);
    J_3 = polyval(J_3_fit,s_3);
end

% Inertia and its derivatives - mathematical form
dJ_3 = interp1(s_3(1:n_3)+ds_3/2,diff(J_3)./ds_3,s_3,'linear','extrap');
d2J_3 = interp1(s_3(1:n_3)+ds_3/2,diff(dJ_3)./ds_3,s_3,'linear','extrap');
d3J_3 = interp1(s_3(1:n_3)+ds_3/2,diff(d2J_3)./ds_3,s_3,'linear','extrap');

%% Calculation of applied loads 1
alpha_1 = atan(double(subs(dy_1,X_1,x_s_1)));     % Angle of inclination of each mesh segment [rad]

q_sw_1 = -Material.gamma.*A_1;                          % Self-weight [kN/m]
% q_ol = interp1(s(1:n)+ds/2,q0.*(x_s(2:n+1)-x_s(1:n))./ds,s,'pchip','extrap');   % Overload [kN/m]
% q_sw = 0;
q_ol_1 = q0.*ones(1,NP_1);
% q_ol = [ zeros(1, floor(1*NP/3)) ones(1,ceil(1*NP/3)+1)*q0 zeros(1, floor(1*NP/3))];
% q_ol = [ ones(1,ceil(NP/2))*q0 zeros(1, floor(NP/2))];


Pn_1 = (q_sw_1 + q_ol_1).*cos(alpha_1);                     % Load normal to the arch [kN/m]
Pt_1 = (q_sw_1 + q_ol_1).*sin(alpha_1);                     % Load tangent to the arch [kN/m]
m_load_1 = 0;                                              % Bending moment [kNm/m]

% Radial load
% Pn = (q_sw).*cos(alpha) + q_ol;                     % Load normal to the arch [kN/m]
% Pt = (q_sw).*sin(alpha);                     % Load tangent to the arch [kN/m] 


dPn_1 = interp1(s_1(1:n_1)+ds_1/2,diff(Pn_1)./ds_1,s_1,'pchip','extrap');   % 1st derivative of normal load

%% Calculation of applied loads 2
alpha_2 = atan(double(subs(dy_2,X_2,x_s_2)));     % Angle of inclination of each mesh segment [rad]

q_sw_2 = -Material.gamma.*A_2;                          % Self-weight [kN/m]
% q_ol = interp1(s(1:n)+ds/2,q0.*(x_s(2:n+1)-x_s(1:n))./ds,s,'pchip','extrap');   % Overload [kN/m]
% q_sw = 0;
q_ol_2 = q0.*ones(1,NP_2);
% q_ol = [ zeros(1, floor(1*NP/3)) ones(1,ceil(1*NP/3)+1)*q0 zeros(1, floor(1*NP/3))];
% q_ol = [ ones(1,ceil(NP/2))*q0 zeros(1, floor(NP/2))];


Pn_2 = (q_sw_2 + q_ol_2).*cos(alpha_2);                     % Load normal to the arch [kN/m]
Pt_2 = (q_sw_2 + q_ol_2).*sin(alpha_2);                     % Load tangent to the arch [kN/m]
m_load_2 = 0;                                              % Bending moment [kNm/m]

% Radial load
% Pn = (q_sw).*cos(alpha) + q_ol;                     % Load normal to the arch [kN/m]
% Pt = (q_sw).*sin(alpha);                     % Load tangent to the arch [kN/m] 


dPn_2 = interp1(s_2(1:n_2)+ds_2/2,diff(Pn_2)./ds_2,s_2,'pchip','extrap');   % 1st derivative of normal load

%% Calculation of applied loads 3
alpha_3 = atan(double(subs(dy_3,X_3,x_s_3)));     % Angle of inclination of each mesh segment [rad]

q_sw_3 = -Material.gamma.*A_3;                          % Self-weight [kN/m]
% q_ol = interp1(s(1:n)+ds/2,q0.*(x_s(2:n+1)-x_s(1:n))./ds,s,'pchip','extrap');   % Overload [kN/m]
% q_sw = 0;
q_ol_3 = q0.*ones(1,NP_3);
% q_ol = [ zeros(1, floor(1*NP/3)) ones(1,ceil(1*NP/3)+1)*q0 zeros(1, floor(1*NP/3))];
% q_ol = [ ones(1,ceil(NP/2))*q0 zeros(1, floor(NP/2))];


Pn_3 = (q_sw_3 + q_ol_3).*cos(alpha_3);                     % Load normal to the arch [kN/m]
Pt_3 = (q_sw_3 + q_ol_3).*sin(alpha_3);                     % Load tangent to the arch [kN/m]
m_load_3 = 0;                                              % Bending moment [kNm/m]

% Radial load
% Pn = (q_sw).*cos(alpha) + q_ol;                     % Load normal to the arch [kN/m]
% Pt = (q_sw).*sin(alpha);                     % Load tangent to the arch [kN/m] 


dPn_3 = interp1(s_3(1:n_3)+ds_3/2,diff(Pn_3)./ds_3,s_3,'pchip','extrap');   % 1st derivative of normal load


%% Calculation of the coefficients of the Equation of the elastic line 1

% Partial coefficients
a4_1 = R_s_1;
b3_1 = R_s_1;
b4_1 = 5.*dR_s_1;
c2_1 = R_s_1;
c3_1 = 4.*dR_s_1;
c4_1 = 10.*d2R_s_1 + 1./R_s_1;
d1_1 = R_s_1;
d2_1 = 3.*dR_s_1;
d3_1 = 6.*d2R_s_1 + 1./R_s_1;
d4_1 = 10.*d3R_s_1 - 4.*dR_s_1.*(1./((R_s_1).^2));
e1_1 = 2.*dR_s_1;
e2_1 = 3.*d2R_s_1 + 1./R_s_1;
e3_1 = 4.*d3R_s_1 - 3.*dR_s_1.*(1./((R_s_1).^2));
e4_1 = 5.*d4R_s_1 - 6.*d2R_s_1.*(1./((R_s_1).^2)) + 12.*((dR_s_1).^2).*(1./((R_s_1).^3));
f1_1 = d2R_s_1 + 1./R_s_1;
f2_1 = d3R_s_1 - 2.*dR_s_1.*(1./((R_s_1).^2));
f3_1 = d4R_s_1 - 3.*d2R_s_1.*(1./((R_s_1).^2)) + 6.*((dR_s_1).^2).*(1./((R_s_1).^3));
f4_1 = d5R_s_1 - 4.*d3R_s_1.*(1./((R_s_1).^2)) + 24.*dR_s_1.*d2R_s_1.*(1./((R_s_1).^3)) - 24.*((dR_s_1).^3).*(1./((R_s_1).^4));
g1_1 = -dR_s_1.*(1./((R_s_1).^2));
g2_1 = -d2R_s_1.*(1./((R_s_1).^2)) + 2.*((dR_s_1).^2).*(1./((R_s_1).^3));
g3_1 = -d3R_s_1.*(1./((R_s_1).^2)) + 6.*dR_s_1.*d2R_s_1.*(1./((R_s_1).^3)) - 6.*((dR_s_1).^3).*(1./((R_s_1).^4));
g4_1 = -d4R_s_1.*(1./((R_s_1).^2)) + 8.*dR_s_1.*d3R_s_1.*(1./((R_s_1).^3)) + 6.*((d2R_s_1).^2).*(1./((R_s_1).^3)) -36.*((dR_s_1).^2).*d2R_s_1.*(1./((R_s_1).^4)) + 24.*((dR_s_1).^4).*(1./((R_s_1).^5));

% Total coefficients
a_1 = (R_s_1.*J_1).*a4_1;
b_1 = (3.*R_s_1.*dJ_1 + dR_s_1.*J_1).*b3_1 + (R_s_1.*J_1).*b4_1;
c_1 = (3.*R_s_1.*d2J_1 + 2.*dR_s_1.*dJ_1 + J_1./R_s_1).*c2_1 + (3.*R_s_1.*dJ_1 + dR_s_1.*J_1).*c3_1 + (R_s_1.*J_1).*c4_1;
d_1 = (R_s_1.*d3J_1 + dR_s_1.*d2J_1 + dJ_1./R_s_1).*d1_1 + (3.*R_s_1.*d2J_1 + 2.*dR_s_1.*dJ_1 + J_1./R_s_1).*d2_1 + (3.*R_s_1.*dJ_1 + dR_s_1.*J_1).*d3_1 + (R_s_1.*J_1).*d4_1;
e_1 = (R_s_1.*d3J_1 + dR_s_1.*d2J_1 + dJ_1./R_s_1).*e1_1 + (3.*R_s_1.*d2J_1 + 2.*dR_s_1.*dJ_1 + J_1./R_s_1).*e2_1 + (3.*R_s_1.*dJ_1 + dR_s_1.*J_1).*e3_1 + (R_s_1.*J_1).*e4_1;
f_1 = (R_s_1.*d3J_1 + dR_s_1.*d2J_1 + dJ_1./R_s_1).*f1_1 + (3.*R_s_1.*d2J_1 + 2.*dR_s_1.*dJ_1 + J_1./R_s_1).*f2_1 + (3.*R_s_1.*dJ_1 + dR_s_1.*J_1).*f3_1 + (R_s_1.*J_1).*f4_1;
g_1 = (R_s_1.*d3J_1 + dR_s_1.*d2J_1 + dJ_1./R_s_1).*g1_1 + (3.*R_s_1.*d2J_1 + 2.*dR_s_1.*dJ_1 + J_1./R_s_1).*g2_1 + (3.*R_s_1.*dJ_1 + dR_s_1.*J_1).*g3_1 + (R_s_1.*J_1).*g4_1;
h_1 = -(Pt_1 + dR_s_1.*Pn_1 + R_s_1.*dPn_1 + m_load_1./R_s_1)./Material.E;

%Coefficients for M,N,T to solver conditions

% Bending moment coefficients
aM_1 = R_s_1;
bM_1 = 2.*dR_s_1;
cM_1 = (d2R_s_1 + 1./R_s_1);
dM_1 = -dR_s_1./(R_s_1).^2;

% Shear force coefficients
aT_1 = R_s_1.*J_1;
bT_1 = R_s_1.*dJ_1 + 3.*dR_s_1.*J_1;
cT_1 = 2.*dR_s_1.*dJ_1 + 3.*d2R_s_1.*J_1 + J_1./R_s_1;
dT_1 = dJ_1.*d2R_s_1 + dJ_1./R_s_1 + d3R_s_1.*J_1 - 2.*J_1.*dR_s_1./(R_s_1).^2;
eT_1 = -(dJ_1.*(dR_s_1./(R_s_1).^2) + J_1.*(d2R_s_1./(R_s_1).^2) -2.*J_1.*((dR_s_1.^2)./(R_s_1).^3));

% Normal force coefficients
aN_1 = R_s_1.*J_1;
bN_1 = 2.*R_s_1.*dJ_1 + 4.*dR_s_1.*J_1;
cN_1 = d2J_1.*R_s_1 + 6.*dJ_1.*dR_s_1 + 6.*J_1.*d2R_s_1 + J_1./R_s_1;
dN_1 = 2.*d2J_1.*dR_s_1 + 6.*dJ_1.*d2R_s_1 + 2.*dJ_1./R_s_1 + 4.*J_1.*d3R_s_1 - 3.*J_1.*dR_s_1./(R_s_1).^2;
eN_1 = d2J_1.*d2R_s_1 + 2.*dJ_1.*d3R_s_1 + J_1.*d4R_s_1 + d2J_1./R_s_1 - 4.*dJ_1.*dR_s_1./(R_s_1.^2) - 3.*J_1.*d2R_s_1./(R_s_1.^2) + 6.*J_1.*(dR_s_1.^2)./(R_s_1.^3);
fN_1 = -d2J_1.*dR_s_1./(R_s_1.^2) - 2.*dJ_1.*d2R_s_1./(R_s_1.^2) - J_1.*d3R_s_1./(R_s_1.^2) + 8.*dJ_1.*(dR_s_1.^2)./(R_s_1.^3) + 2.*J_1.*dR_s_1.*d2R_s_1./(R_s_1.^3) - 6.*J_1.*(dR_s_1.^3)./(R_s_1.^4);


%% Calculation of the coefficients of the Equation of the elastic line 2

% Partial coefficients
a4_2 = R_s_2;
b3_2 = R_s_2;
b4_2 = 5.*dR_s_2;
c2_2 = R_s_2;
c3_2 = 4.*dR_s_2;
c4_2 = 10.*d2R_s_2 + 1./R_s_2;
d1_2 = R_s_2;
d2_2 = 3.*dR_s_2;
d3_2 = 6.*d2R_s_2 + 1./R_s_2;
d4_2 = 10.*d3R_s_2 - 4.*dR_s_2.*(1./((R_s_2).^2));
e1_2 = 2.*dR_s_2;
e2_2 = 3.*d2R_s_2 + 1./R_s_2;
e3_2 = 4.*d3R_s_2 - 3.*dR_s_2.*(1./((R_s_2).^2));
e4_2 = 5.*d4R_s_2 - 6.*d2R_s_2.*(1./((R_s_2).^2)) + 12.*((dR_s_2).^2).*(1./((R_s_2).^3));
f1_2 = d2R_s_2 + 1./R_s_2;
f2_2 = d3R_s_2 - 2.*dR_s_2.*(1./((R_s_2).^2));
f3_2 = d4R_s_2 - 3.*d2R_s_2.*(1./((R_s_2).^2)) + 6.*((dR_s_2).^2).*(1./((R_s_2).^3));
f4_2 = d5R_s_2 - 4.*d3R_s_2.*(1./((R_s_2).^2)) + 24.*dR_s_2.*d2R_s_2.*(1./((R_s_2).^3)) - 24.*((dR_s_2).^3).*(1./((R_s_2).^4));
g1_2 = -dR_s_2.*(1./((R_s_2).^2));
g2_2 = -d2R_s_2.*(1./((R_s_2).^2)) + 2.*((dR_s_2).^2).*(1./((R_s_2).^3));
g3_2 = -d3R_s_2.*(1./((R_s_2).^2)) + 6.*dR_s_2.*d2R_s_2.*(1./((R_s_2).^3)) - 6.*((dR_s_2).^3).*(1./((R_s_2).^4));
g4_2 = -d4R_s_2.*(1./((R_s_2).^2)) + 8.*dR_s_2.*d3R_s_2.*(1./((R_s_2).^3)) + 6.*((d2R_s_2).^2).*(1./((R_s_2).^3)) -36.*((dR_s_2).^2).*d2R_s_2.*(1./((R_s_2).^4)) + 24.*((dR_s_2).^4).*(1./((R_s_2).^5));

% Total coefficients
a_2 = (R_s_2.*J_2).*a4_2;
b_2 = (3.*R_s_2.*dJ_2 + dR_s_2.*J_2).*b3_2 + (R_s_2.*J_2).*b4_2;
c_2 = (3.*R_s_2.*d2J_2 + 2.*dR_s_2.*dJ_2 + J_2./R_s_2).*c2_2 + (3.*R_s_2.*dJ_2 + dR_s_2.*J_2).*c3_2 + (R_s_2.*J_2).*c4_2;
d_2 = (R_s_2.*d3J_2 + dR_s_2.*d2J_2 + dJ_2./R_s_2).*d1_2 + (3.*R_s_2.*d2J_2 + 2.*dR_s_2.*dJ_2 + J_2./R_s_2).*d2_2 + (3.*R_s_2.*dJ_2 + dR_s_2.*J_2).*d3_2 + (R_s_2.*J_2).*d4_2;
e_2 = (R_s_2.*d3J_2 + dR_s_2.*d2J_2 + dJ_2./R_s_2).*e1_2 + (3.*R_s_2.*d2J_2 + 2.*dR_s_2.*dJ_2 + J_2./R_s_2).*e2_2 + (3.*R_s_2.*dJ_2 + dR_s_2.*J_2).*e3_2 + (R_s_2.*J_2).*e4_2;
f_2 = (R_s_2.*d3J_2 + dR_s_2.*d2J_2 + dJ_2./R_s_2).*f1_2 + (3.*R_s_2.*d2J_2 + 2.*dR_s_2.*dJ_2 + J_2./R_s_2).*f2_2 + (3.*R_s_2.*dJ_2 + dR_s_2.*J_2).*f3_2 + (R_s_2.*J_2).*f4_2;
g_2 = (R_s_2.*d3J_2 + dR_s_2.*d2J_2 + dJ_2./R_s_2).*g1_2 + (3.*R_s_2.*d2J_2 + 2.*dR_s_2.*dJ_2 + J_2./R_s_2).*g2_2 + (3.*R_s_2.*dJ_2 + dR_s_2.*J_2).*g3_2 + (R_s_2.*J_2).*g4_2;
h_2 = -(Pt_2 + dR_s_2.*Pn_2 + R_s_2.*dPn_2 + m_load_2./R_s_2)./Material.E;

%Coefficients for M,N,T to solver conditions

% Bending moment coefficients
aM_2 = R_s_2;
bM_2 = 2.*dR_s_2;
cM_2 = (d2R_s_2 + 1./R_s_2);
dM_2 = -dR_s_2./(R_s_2).^2;

% Shear force coefficients
aT_2 = R_s_2.*J_2;
bT_2 = R_s_2.*dJ_2 + 3.*dR_s_2.*J_2;
cT_2 = 2.*dR_s_2.*dJ_2 + 3.*d2R_s_2.*J_2 + J_2./R_s_2;
dT_2 = dJ_2.*d2R_s_2 + dJ_2./R_s_2 + d3R_s_2.*J_2 - 2.*J_2.*dR_s_2./(R_s_2).^2;
eT_2 = -(dJ_2.*(dR_s_2./(R_s_2).^2) + J_2.*(d2R_s_2./(R_s_2).^2) -2.*J_2.*((dR_s_2.^2)./(R_s_2).^3));

% Normal force coefficients
aN_2 = R_s_2.*J_2;
bN_2 = 2.*R_s_2.*dJ_2 + 4.*dR_s_2.*J_2;
cN_2 = d2J_2.*R_s_2 + 6.*dJ_2.*dR_s_2 + 6.*J_2.*d2R_s_2 + J_2./R_s_2;
dN_2 = 2.*d2J_2.*dR_s_2 + 6.*dJ_2.*d2R_s_2 + 2.*dJ_2./R_s_2 + 4.*J_2.*d3R_s_2 - 3.*J_2.*dR_s_2./(R_s_2).^2;
eN_2 = d2J_2.*d2R_s_2 + 2.*dJ_2.*d3R_s_2 + J_2.*d4R_s_2 + d2J_2./R_s_2 - 4.*dJ_2.*dR_s_2./(R_s_2.^2) - 3.*J_2.*d2R_s_2./(R_s_2.^2) + 6.*J_2.*(dR_s_2.^2)./(R_s_2.^3);
fN_2 = -d2J_2.*dR_s_2./(R_s_2.^2) - 2.*dJ_2.*d2R_s_2./(R_s_2.^2) - J_2.*d3R_s_2./(R_s_2.^2) + 8.*dJ_2.*(dR_s_2.^2)./(R_s_2.^3) + 2.*J_2.*dR_s_2.*d2R_s_2./(R_s_2.^3) - 6.*J_2.*(dR_s_2.^3)./(R_s_2.^4);

%% Calculation of the coefficients of the Equation of the elastic line 3

% Partial coefficients
a4_3 = R_s_3;
b3_3 = R_s_3;
b4_3 = 5.*dR_s_3;
c2_3 = R_s_3;
c3_3 = 4.*dR_s_3;
c4_3 = 10.*d2R_s_3 + 1./R_s_3;
d1_3 = R_s_3;
d2_3 = 3.*dR_s_3;
d3_3 = 6.*d2R_s_3 + 1./R_s_3;
d4_3 = 10.*d3R_s_3 - 4.*dR_s_3.*(1./((R_s_3).^2));
e1_3 = 2.*dR_s_3;
e2_3 = 3.*d2R_s_3 + 1./R_s_3;
e3_3 = 4.*d3R_s_3 - 3.*dR_s_3.*(1./((R_s_3).^2));
e4_3 = 5.*d4R_s_3 - 6.*d2R_s_3.*(1./((R_s_3).^2)) + 12.*((dR_s_3).^2).*(1./((R_s_3).^3));
f1_3 = d2R_s_3 + 1./R_s_3;
f2_3 = d3R_s_3 - 2.*dR_s_3.*(1./((R_s_3).^2));
f3_3 = d4R_s_3 - 3.*d2R_s_3.*(1./((R_s_3).^2)) + 6.*((dR_s_3).^2).*(1./((R_s_3).^3));
f4_3 = d5R_s_3 - 4.*d3R_s_3.*(1./((R_s_3).^2)) + 24.*dR_s_3.*d2R_s_3.*(1./((R_s_3).^3)) - 24.*((dR_s_3).^3).*(1./((R_s_3).^4));
g1_3 = -dR_s_3.*(1./((R_s_3).^2));
g2_3 = -d2R_s_3.*(1./((R_s_3).^2)) + 2.*((dR_s_3).^2).*(1./((R_s_3).^3));
g3_3 = -d3R_s_3.*(1./((R_s_3).^2)) + 6.*dR_s_3.*d2R_s_3.*(1./((R_s_3).^3)) - 6.*((dR_s_3).^3).*(1./((R_s_3).^4));
g4_3 = -d4R_s_3.*(1./((R_s_3).^2)) + 8.*dR_s_3.*d3R_s_3.*(1./((R_s_3).^3)) + 6.*((d2R_s_3).^2).*(1./((R_s_3).^3)) -36.*((dR_s_3).^2).*d2R_s_3.*(1./((R_s_3).^4)) + 24.*((dR_s_3).^4).*(1./((R_s_3).^5));

% Total coefficients
a_3 = (R_s_3.*J_3).*a4_3;
b_3 = (3.*R_s_3.*dJ_3 + dR_s_3.*J_3).*b3_3 + (R_s_3.*J_3).*b4_3;
c_3 = (3.*R_s_3.*d2J_3 + 2.*dR_s_3.*dJ_3 + J_3./R_s_3).*c2_3 + (3.*R_s_3.*dJ_3 + dR_s_3.*J_3).*c3_3 + (R_s_3.*J_3).*c4_3;
d_3 = (R_s_3.*d3J_3 + dR_s_3.*d2J_3 + dJ_3./R_s_3).*d1_3 + (3.*R_s_3.*d2J_3 + 2.*dR_s_3.*dJ_3 + J_3./R_s_3).*d2_3 + (3.*R_s_3.*dJ_3 + dR_s_3.*J_3).*d3_3 + (R_s_3.*J_3).*d4_3;
e_3 = (R_s_3.*d3J_3 + dR_s_3.*d2J_3 + dJ_3./R_s_3).*e1_3 + (3.*R_s_3.*d2J_3 + 2.*dR_s_3.*dJ_3 + J_3./R_s_3).*e2_3 + (3.*R_s_3.*dJ_3 + dR_s_3.*J_3).*e3_3 + (R_s_3.*J_3).*e4_3;
f_3 = (R_s_3.*d3J_3 + dR_s_3.*d2J_3 + dJ_3./R_s_3).*f1_3 + (3.*R_s_3.*d2J_3 + 2.*dR_s_3.*dJ_3 + J_3./R_s_3).*f2_3 + (3.*R_s_3.*dJ_3 + dR_s_3.*J_3).*f3_3 + (R_s_3.*J_3).*f4_3;
g_3 = (R_s_3.*d3J_3 + dR_s_3.*d2J_3 + dJ_3./R_s_3).*g1_3 + (3.*R_s_3.*d2J_3 + 2.*dR_s_3.*dJ_3 + J_3./R_s_3).*g2_3 + (3.*R_s_3.*dJ_3 + dR_s_3.*J_3).*g3_3 + (R_s_3.*J_3).*g4_3;
h_3 = -(Pt_3 + dR_s_3.*Pn_3 + R_s_3.*dPn_3 + m_load_3./R_s_3)./Material.E;

%Coefficients for M,N,T to solver conditions

% Bending moment coefficients
aM_3 = R_s_3;
bM_3 = 2.*dR_s_3;
cM_3 = (d2R_s_3 + 1./R_s_3);
dM_3 = -dR_s_3./(R_s_3).^2;

% Shear force coefficients
aT_3 = R_s_3.*J_3;
bT_3 = R_s_3.*dJ_3 + 3.*dR_s_3.*J_3;
cT_3 = 2.*dR_s_3.*dJ_3 + 3.*d2R_s_3.*J_3 + J_3./R_s_3;
dT_3 = dJ_3.*d2R_s_3 + dJ_3./R_s_3 + d3R_s_3.*J_3 - 2.*J_3.*dR_s_3./(R_s_3).^2;
eT_3 = -(dJ_3.*(dR_s_3./(R_s_3).^2) + J_3.*(d2R_s_3./(R_s_3).^2) -2.*J_3.*((dR_s_3.^2)./(R_s_3).^3));

% Normal force coefficients
aN_3 = R_s_3.*J_3;
bN_3 = 2.*R_s_3.*dJ_3 + 4.*dR_s_3.*J_3;
cN_3 = d2J_3.*R_s_3 + 6.*dJ_3.*dR_s_3 + 6.*J_3.*d2R_s_3 + J_3./R_s_3;
dN_3 = 2.*d2J_3.*dR_s_3 + 6.*dJ_3.*d2R_s_3 + 2.*dJ_3./R_s_3 + 4.*J_3.*d3R_s_3 - 3.*J_3.*dR_s_3./(R_s_3).^2;
eN_3 = d2J_3.*d2R_s_3 + 2.*dJ_3.*d3R_s_3 + J_3.*d4R_s_3 + d2J_3./R_s_3 - 4.*dJ_3.*dR_s_3./(R_s_3.^2) - 3.*J_3.*d2R_s_3./(R_s_3.^2) + 6.*J_3.*(dR_s_3.^2)./(R_s_3.^3);
fN_3 = -d2J_3.*dR_s_3./(R_s_3.^2) - 2.*dJ_3.*d2R_s_3./(R_s_3.^2) - J_3.*d3R_s_3./(R_s_3.^2) + 8.*dJ_3.*(dR_s_3.^2)./(R_s_3.^3) + 2.*J_3.*dR_s_3.*d2R_s_3./(R_s_3.^3) - 6.*J_3.*(dR_s_3.^3)./(R_s_3.^4);



%% Displacements - Finite Differences solution
% Initial condition
u_0_1 = 0.01*sin((pi/(s_1(end).*0.5)).*s_1_exp);
u_0_2 = 0.01*sin((pi/(s_2(end).*0.5)).*s_2_exp);
u_0_3 = 0.01*sin((pi/(s_3(end).*0.5)).*s_3_exp);
u0 = [u_0_1 u_0_2 u_0_3];

% Solver
% options = optimoptions('fsolve','Algorithm', 'levenberg-marquardt'); % algorithm for solving linear system
u_exp = fsolve('solver_v4hingebis',u0);
u_1_exp = u_exp(1:NP_1+6);
u_3_exp = u_exp(HP1+1:HP2);
u_2_exp = u_exp(HP2+1:HP2+NP_2+6);

%% 1 
% Calculation of the tangential displacements and its derivatives
u_1 = u_1_exp(4:NP_1+3);
du_1 = ((-1/60).*u_1_exp(1:NP_1) + (3/20).*u_1_exp(2:NP_1+1) + (-3/4).*u_1_exp(3:NP_1+2) + (0).*u_1_exp(4:NP_1+3) + (3/4).*u_1_exp(5:NP_1+4) + (-3/20).*u_1_exp(6:NP_1+5) + (1/60).*u_1_exp(7:NP_1+6))./ds_1;
d2u_1 = ((1/90).*u_1_exp(1:NP_1) + (-3/20).*u_1_exp(2:NP_1+1) + (3/2).*u_1_exp(3:NP_1+2) + (-49/18).*u_1_exp(4:NP_1+3) + (3/2).*u_1_exp(5:NP_1+4) + (-3/20).*u_1_exp(6:NP_1+5) + (1/90).*u_1_exp(7:NP_1+6))./(ds_1^2);
d3u_1 = ((1/8).*u_1_exp(1:NP_1) + (-1).*u_1_exp(2:NP_1+1) + (13/8).*u_1_exp(3:NP_1+2) + (0).*u_1_exp(4:NP_1+3) + (-13/8).*u_1_exp(5:NP_1+4) + (1).*u_1_exp(6:NP_1+5) + (-1/8).*u_1_exp(7:NP_1+6))./(ds_1^3);
d4u_1 = ((-1/6).*u_1_exp(1:NP_1) + (2).*u_1_exp(2:NP_1+1) + (-13/2).*u_1_exp(3:NP_1+2) + (28/3).*u_1_exp(4:NP_1+3) + (-13/2).*u_1_exp(5:NP_1+4) + (2).*u_1_exp(6:NP_1+5) + (-1/6).*u_1_exp(7:NP_1+6))./(ds_1^4);
d5u_1 = ((-1/2).*u_1_exp(1:NP_1) + (2).*u_1_exp(2:NP_1+1) + (-5/2).*u_1_exp(3:NP_1+2) + (0).*u_1_exp(4:NP_1+3) + (5/2).*u_1_exp(5:NP_1+4) + (-2).*u_1_exp(6:NP_1+5) + (1/2).*u_1_exp(7:NP_1+6))./(ds_1^5);

% Perpendicular displacements [m]
v_1 = -du_1.*R_s_1;

% Rotations [rad]
phi_1 = -(d2u_1.*R_s_1 + du_1.*dR_s_1 + u_1./R_s_1);

% Deformation angle and its derivatives
k_1 = d3u_1.*d1_1 + d2u_1.*e1_1 + du_1.*f1_1 + u_1.*g1_1;
dk_1 = c2_1.*d4u_1 + d2_1.*d3u_1 + e2_1.*d2u_1 + f2_1.*du_1 + g2_1.*u_1;
d2k_1 = b3_1.*d5u_1 + c3_1.*d4u_1 + d3_1.*d3u_1 + e3_1.*d2u_1 + f3_1.*du_1 + g3_1.*u_1;

%% 2
% Calculation of the tangential displacements and its derivatives
u_2 = u_2_exp(4:NP_2+3);
du_2 = ((-1/60).*u_2_exp(1:NP_2) + (3/20).*u_2_exp(2:NP_2+1) + (-3/4).*u_2_exp(3:NP_2+2) + (0).*u_2_exp(4:NP_2+3) + (3/4).*u_2_exp(5:NP_2+4) + (-3/20).*u_2_exp(6:NP_2+5) + (1/60).*u_2_exp(7:NP_2+6))./ds_2;
d2u_2 = ((1/90).*u_2_exp(1:NP_2) + (-3/20).*u_2_exp(2:NP_2+1) + (3/2).*u_2_exp(3:NP_2+2) + (-49/18).*u_2_exp(4:NP_2+3) + (3/2).*u_2_exp(5:NP_2+4) + (-3/20).*u_2_exp(6:NP_2+5) + (1/90).*u_2_exp(7:NP_2+6))./(ds_2^2);
d3u_2 = ((1/8).*u_2_exp(1:NP_2) + (-1).*u_2_exp(2:NP_2+1) + (13/8).*u_2_exp(3:NP_2+2) + (0).*u_2_exp(4:NP_2+3) + (-13/8).*u_2_exp(5:NP_2+4) + (1).*u_2_exp(6:NP_2+5) + (-1/8).*u_2_exp(7:NP_2+6))./(ds_2^3);
d4u_2 = ((-1/6).*u_2_exp(1:NP_2) + (2).*u_2_exp(2:NP_2+1) + (-13/2).*u_2_exp(3:NP_2+2) + (28/3).*u_2_exp(4:NP_2+3) + (-13/2).*u_2_exp(5:NP_2+4) + (2).*u_2_exp(6:NP_2+5) + (-1/6).*u_2_exp(7:NP_2+6))./(ds_2^4);
d5u_2 = ((-1/2).*u_2_exp(1:NP_2) + (2).*u_2_exp(2:NP_2+1) + (-5/2).*u_2_exp(3:NP_2+2) + (0).*u_2_exp(4:NP_2+3) + (5/2).*u_2_exp(5:NP_2+4) + (-2).*u_2_exp(6:NP_2+5) + (1/2).*u_2_exp(7:NP_2+6))./(ds_2^5);

% Perpendicular displacements [m]
v_2 = -du_2.*R_s_2;

% Rotations [rad]
phi_2 = -(d2u_2.*R_s_2 + du_2.*dR_s_2 + u_2./R_s_2);

% Deformation angle and its derivatives
k_2 = d3u_2.*d1_2 + d2u_2.*e1_2 + du_2.*f1_2 + u_2.*g1_2;
dk_2 = c2_2.*d4u_2 + d2_2.*d3u_2 + e2_2.*d2u_2 + f2_2.*du_2 + g2_2.*u_2;
d2k_2 = b3_2.*d5u_2 + c3_2.*d4u_2 + d3_2.*d3u_2 + e3_2.*d2u_2 + f3_2.*du_2 + g3_2.*u_2;

%% 3

% Calculation of the tangential displacements and its derivatives
u_3 = u_3_exp(4:NP_3+3);
du_3 = ((-1/60).*u_3_exp(1:NP_3) + (3/20).*u_3_exp(2:NP_3+1) + (-3/4).*u_3_exp(3:NP_3+2) + (0).*u_3_exp(4:NP_3+3) + (3/4).*u_3_exp(5:NP_3+4) + (-3/20).*u_3_exp(6:NP_3+5) + (1/60).*u_3_exp(7:NP_3+6))./ds_3;
d2u_3 = ((1/90).*u_3_exp(1:NP_3) + (-3/20).*u_3_exp(2:NP_3+1) + (3/2).*u_3_exp(3:NP_3+2) + (-49/18).*u_3_exp(4:NP_3+3) + (3/2).*u_3_exp(5:NP_3+4) + (-3/20).*u_3_exp(6:NP_3+5) + (1/90).*u_3_exp(7:NP_3+6))./(ds_3^2);
d3u_3 = ((1/8).*u_3_exp(1:NP_3) + (-1).*u_3_exp(2:NP_3+1) + (13/8).*u_3_exp(3:NP_3+2) + (0).*u_3_exp(4:NP_3+3) + (-13/8).*u_3_exp(5:NP_3+4) + (1).*u_3_exp(6:NP_3+5) + (-1/8).*u_3_exp(7:NP_3+6))./(ds_3^3);
d4u_3 = ((-1/6).*u_3_exp(1:NP_3) + (2).*u_3_exp(2:NP_3+1) + (-13/2).*u_3_exp(3:NP_3+2) + (28/3).*u_3_exp(4:NP_3+3) + (-13/2).*u_3_exp(5:NP_3+4) + (2).*u_3_exp(6:NP_3+5) + (-1/6).*u_3_exp(7:NP_3+6))./(ds_3^4);
d5u_3 = ((-1/2).*u_3_exp(1:NP_3) + (2).*u_3_exp(2:NP_3+1) + (-5/2).*u_3_exp(3:NP_3+2) + (0).*u_3_exp(4:NP_3+3) + (5/2).*u_3_exp(5:NP_3+4) + (-2).*u_3_exp(6:NP_3+5) + (1/2).*u_3_exp(7:NP_3+6))./(ds_3^5);

% Perpendicular displacements [m]
v_3 = -du_3.*R_s_3;

% Rotations [rad]
phi_3 = -(d2u_3.*R_s_3 + du_3.*dR_s_3 + u_3./R_s_3);

% Deformation angle and its derivatives
k_3 = d3u_3.*d1_3 + d2u_3.*e1_3 + du_3.*f1_3 + u_3.*g1_3;
dk_3 = c2_3.*d4u_3 + d2_3.*d3u_3 + e2_3.*d2u_3 + f2_3.*du_3 + g2_3.*u_3;
d2k_3 = b3_3.*d5u_3 + c3_3.*d4u_3 + d3_3.*d3u_3 + e3_3.*d2u_3 + f3_3.*du_3 + g3_3.*u_3;


%% Stabilization of d2k in case of discontinuous overload 1
for i=1:NP_1-1
    if q_ol_1(i) ~= 0
        if q_ol_1(i+1) == 0
            d2k_1(i) = interp1(s_1(1:i-1), d2k_1(1:i-1), s_1(i), 'pchip','extrap');
            d2k_1(i+1) = interp1(s_1(i+2:NP_1), d2k_1(i+2:NP_1), s_1(i+1), 'pchip','extrap');
        end
    else
        if q_ol_1(i+1) ~= 0
            d2k_1(i) = interp1(s_1(1:i-1), d2k_1(1:i-1), s_1(i), 'pchip','extrap');
            d2k_1(i+1) = interp1(s_1(i+2:NP_1), d2k_1(i+2:NP_1), s_1(i+1), 'pchip','extrap');
        end
    end            
end

%% Stabilization of d2k in case of discontinuous overload 2
for i=1:NP_2-1
    if q_ol_2(i) ~= 0
        if q_ol_2(i+1) == 0
            d2k_2(i) = interp1(s_2(1:i-1), d2k_2(1:i-1), s_2(i), 'pchip','extrap');
            d2k_2(i+1) = interp1(s_2(i+2:NP_2), d2k_2(i+2:NP_2), s_2(i+1), 'pchip','extrap');
        end
    else
        if q_ol_2(i+1) ~= 0
            d2k_2(i) = interp1(s_2(1:i-1), d2k_2(1:i-1), s_2(i), 'pchip','extrap');
            d2k_2(i+1) = interp1(s_2(i+2:NP_2), d2k_2(i+2:NP_2), s_2(i+1), 'pchip','extrap');
        end
    end            
end

%% Stabilization of d2k in case of discontinuous overload 3
for i=1:NP_3-1
    if q_ol_3(i) ~= 0
        if q_ol_3(i+1) == 0
            d2k_3(i) = interp1(s_3(1:i-1), d2k_3(1:i-1), s_3(i), 'pchip','extrap');
            d2k_3(i+1) = interp1(s_3(i+2:NP_3), d2k_3(i+2:NP_3), s_3(i+1), 'pchip','extrap');
        end
    else
        if q_ol_3(i+1) ~= 0
            d2k_3(i) = interp1(s_3(1:i-1), d2k_3(1:i-1), s_3(i), 'pchip','extrap');
            d2k_3(i+1) = interp1(s_3(i+2:NP_3), d2k_3(i+2:NP_3), s_3(i+1), 'pchip','extrap');
        end
    end            
end




%% Solicitations 1
M_1 = Material.E.*J_1.*k_1;                                           % Bending Moment [kNm]
T_1 = Material.E.*-(dJ_1.*k_1 + J_1.*dk_1) + m_load_1;                           % Shear [kN]
N_1 = R_s_1.*Pn_1 - R_s_1.*Material.E.*(d2J_1.*k_1 + 2.*dJ_1.*dk_1 + J_1.*d2k_1);       % Axial force [kN]

Dz_1 = -(v_1.*cos(alpha_1)+u_1.*sin(alpha_1));
Dx_1 = -(-v_1.*sin(alpha_1)+u_1.*cos(alpha_1));

Results_1 = [Dx_1' Dz_1' phi_1' M_1' N_1' T_1'];
z1_1 = double(subs(y_1,X_1,x_s_1));

%% Solicitations 2
M_2 = Material.E.*J_2.*k_2;                                           % Bending Moment [kNm]
T_2 = Material.E.*-(dJ_2.*k_2 + J_2.*dk_2) + m_load_2;                           % Shear [kN]
N_2 = R_s_2.*Pn_2 - R_s_2.*Material.E.*(d2J_2.*k_2 + 2.*dJ_2.*dk_2 + J_2.*d2k_2);       % Axial force [kN]

Dz_2 = -(v_2.*cos(alpha_2)+u_2.*sin(alpha_2));
Dx_2 = -(-v_2.*sin(alpha_2)+u_2.*cos(alpha_2));

Results_2 = [Dx_2' Dz_2' phi_2' M_2' N_2' T_2'];
z1_2 = double(subs(y_2,X_2,x_s_2));

%% Solicitations 3
M_3 = Material.E.*J_3.*k_3;                                           % Bending Moment [kNm]
T_3 = Material.E.*-(dJ_3.*k_3 + J_3.*dk_3) + m_load_3;                           % Shear [kN]
N_3 = R_s_3.*Pn_3 - R_s_3.*Material.E.*(d2J_3.*k_3 + 2.*dJ_3.*dk_3 + J_3.*d2k_3);       % Axial force [kN]

Dz_3 = -(v_3.*cos(alpha_3)+u_3.*sin(alpha_3));
Dx_3 = -(-v_3.*sin(alpha_3)+u_3.*cos(alpha_3));

Results_3 = [Dx_3' Dz_3' phi_3' M_3' N_3' T_3'];
z1_3 = double(subs(y_3,X_3,x_s_3));

%% Stresses 1
sigma_1 = (M_1./W_1 + N_1./A_1)./1000;                                    % Normal stress [MPa]

sigma_1_max = max(abs(sigma_1));

constraint_1 = sigma_1_max/Material.fyd - 1;                                 % Strength verification

%% Stresses 2
sigma_2 = (M_2./W_2 + N_2./A_2)./1000;                                    % Normal stress [MPa]

sigma_2_max = max(abs(sigma_2));

constraint_2 = sigma_2_max/Material.fyd - 1;                                 % Strength verification

%% Stresses 3
sigma_3 = (M_3./W_3 + N_3./A_3)./1000;                                    % Normal stress [MPa]

sigma_3_max = max(abs(sigma_3));

constraint_3 = sigma_3_max/Material.fyd - 1;                                 % Strength verification

%% Von Mises stress calculation 1
z_1 = [-r1_1; -(2/3).*r1_1; -(1/3).*r1_1; zeros(1,length(r1_1)); (1/3).*r1_1; (2/3).*r1_1; r1_1];

if Section.type == 1                % Circular
    sigma_1_NM = (z_1.*M_1./J_1 + N_1./A_1)./1000;
elseif Section.type == 2            % Ellipsoidal Pay attention, you are using the circular approximation!!!!!!!!!!!!!!!!!!!)
    sigma_1_NM = (z_1.*M_1./J_1 + N_1./A_1)./1000;
elseif Section.type == 3            % Square
    sigma_1_NM = ((z_1./2).*M_1./J_1 + N_1./A_1)./1000;
elseif Section.type == 4            % Rectangular
    sigma_1_NM = ((z_1./2).*M_1./J_1 + N_1./A_1)./1000;
elseif Section.type == 5            % Hollowed circular
    sigma_1_NM = (z_1.*M_1./J_1 + N_1./A_1)./1000;
elseif Section.type == 6            % Hollowed square
    sigma_1_NM = ((z_1./2).*M_1./J_1 + N_1./A_1)./1000;
elseif Section.type == 7            % Hollowed rectangular
    sigma_1_NM = ((z_1./2).*M_1./J_1 + N_1./A_1)./1000;
end

if Section.type == 1                % Circular
    tau_1_max = ((4/3).*(T_1./A_1))./1000;
    tau_1 = -(tau_1_max./(r1_1.^2)).*(z_1.^2) + tau_1_max;
elseif Section.type == 2            % Ellipsoidal Pay attention, you are using the circular approximation!!!!!!!!!!!!!!!!!!!)
    tau_1_max = ((4/3).*(T_1./A_1))./1000;
    tau_1 = -(tau_1_max./(r1_1.^2)).*(z_1.^2) + tau_1_max;
elseif Section.type == 3            % Square
    tau_1_max = ((3/2).*(T_1./A_1))./1000;
    tau_1 = -(tau_1_max./((r1_1/2).^2)).*((z_1./2).^2) + tau_1_max;
elseif Section.type == 4            % Rectangular
    tau_1_max = ((3/2).*(T_1./A_1))./1000;
    tau_1 = -(tau_1_max./((r1_1/2).^2)).*((z_1./2).^2) + tau_1_max;
elseif Section.type == 5            % Hollowed circular
    tau_1_max = (2.*(T_1./A_1))./1000;
    tau_1 = -(tau_1_max./(r1_1.^2)).*(z_1.^2) + tau_1_max;
elseif Section.type == 6            % Hollowed square
    tau_1_max = (T_1./(A_1 - (2.*r1_1.*t_1)))./1000;
    tau_1 = tau_1_max;
elseif Section.type == 7            % Hollowed rectangular
    tau_1_max = (T_1./(A_1-(2.*r2_1.*t_1)))./1000;
    tau_1 = tau_1_max;   
end

sigma_1_VM = ((sigma_1_NM.^2) + 3.*(tau_1.^2)).^0.5;

sigma_1_max_VM = max(max(abs(sigma_1_VM)));

sigma_1_VMmax = max(abs(sigma_1_VM));

AAAA_1 = [s_1' sigma_1_VMmax'];



%% Von Mises stress calculation 2
z_2 = [-r1_2; -(2/3).*r1_2; -(1/3).*r1_2; zeros(1,length(r1_2)); (1/3).*r1_2; (2/3).*r1_2; r1_2];

if Section.type == 1                % Circular
    sigma_2_NM = (z_2.*M_2./J_2 + N_2./A_2)./1000;
elseif Section.type == 2            % Ellipsoidal Pay attention, you are using the circular approximation!!!!!!!!!!!!!!!!!!!)
    sigma_2_NM = (z_2.*M_2./J_2 + N_2./A_2)./1000;
elseif Section.type == 3            % Square
    sigma_2_NM = ((z_2./2).*M_2./J_2 + N_2./A_2)./1000;
elseif Section.type == 4            % Rectangular
    sigma_2_NM = ((z_2./2).*M_2./J_2 + N_2./A_2)./1000;
elseif Section.type == 5            % Hollowed circular
    sigma_2_NM = (z_2.*M_2./J_2 + N_2./A_2)./1000;
elseif Section.type == 6            % Hollowed square
    sigma_2_NM = ((z_2./2).*M_2./J_2 + N_2./A_2)./1000;
elseif Section.type == 7            % Hollowed rectangular
    sigma_2_NM = ((z_2./2).*M_2./J_2 + N_2./A_2)./1000;
end

if Section.type == 1                % Circular
    tau_2_max = ((4/3).*(T_2./A_2))./1000;
    tau_2 = -(tau_2_max./(r1_2.^2)).*(z_2.^2) + tau_2_max;
elseif Section.type == 2            % Ellipsoidal Pay attention, you are using the circular approximation!!!!!!!!!!!!!!!!!!!)
    tau_2_max = ((4/3).*(T_2./A_2))./1000;
    tau_2 = -(tau_2_max./(r1_2.^2)).*(z_2.^2) + tau_2_max;
elseif Section.type == 3            % Square
    tau_2_max = ((3/2).*(T_2./A_2))./1000;
    tau_2 = -(tau_2_max./((r1_2/2).^2)).*((z_2./2).^2) + tau_2_max;
elseif Section.type == 4            % Rectangular
    tau_2_max = ((3/2).*(T_2./A_2))./1000;
    tau_2 = -(tau_2_max./((r1_2/2).^2)).*((z_2./2).^2) + tau_2_max;
elseif Section.type == 5            % Hollowed circular
    tau_2_max = (2.*(T_2./A_2))./1000;
    tau_2 = -(tau_2_max./(r1_2.^2)).*(z_2.^2) + tau_2_max;
elseif Section.type == 6            % Hollowed square
    tau_2_max = (T_2./(A_2 - (2.*r1_2.*t_2)))./1000;
    tau_2 = tau_2_max;
elseif Section.type == 7            % Hollowed rectangular
    tau_2_max = (T_2./(A_2-(2.*r2_2.*t_2)))./1000;
    tau_2 = tau_2_max;   
end

sigma_2_VM = ((sigma_2_NM.^2) + 3.*(tau_2.^2)).^0.5;

sigma_2_max_VM = max(max(abs(sigma_2_VM)));

sigma_2_VMmax = max(abs(sigma_2_VM));

AAAA_2 = [s_2' sigma_2_VMmax'];

%% Von Mises stress calculation 3
z_3 = [-r1_3; -(2/3).*r1_3; -(1/3).*r1_3; zeros(1,length(r1_3)); (1/3).*r1_3; (2/3).*r1_3; r1_3];

if Section.type == 1                % Circular
    sigma_3_NM = (z_3.*M_3./J_3 + N_3./A_3)./1000;
elseif Section.type == 2            % Ellipsoidal Pay attention, you are using the circular approximation!!!!!!!!!!!!!!!!!!!)
    sigma_3_NM = (z_3.*M_3./J_3 + N_3./A_3)./1000;
elseif Section.type == 3            % Square
    sigma_3_NM = ((z_3./2).*M_3./J_3 + N_3./A_3)./1000;
elseif Section.type == 4            % Rectangular
    sigma_3_NM = ((z_3./2).*M_3./J_3 + N_3./A_3)./1000;
elseif Section.type == 5            % Hollowed circular
    sigma_3_NM = (z_3.*M_3./J_3 + N_3./A_3)./1000;
elseif Section.type == 6            % Hollowed square
    sigma_3_NM = ((z_3./2).*M_3./J_3 + N_3./A_3)./1000;
elseif Section.type == 7            % Hollowed rectangular
    sigma_3_NM = ((z_3./2).*M_3./J_3 + N_3./A_3)./1000;
end

if Section.type == 1                % Circular
    tau_3_max = ((4/3).*(T_3./A_3))./1000;
    tau_3 = -(tau_3_max./(r1_3.^2)).*(z_3.^2) + tau_3_max;
elseif Section.type == 2            % Ellipsoidal Pay attention, you are using the circular approximation!!!!!!!!!!!!!!!!!!!)
    tau_3_max = ((4/3).*(T_3./A_3))./1000;
    tau_3 = -(tau_3_max./(r1_3.^2)).*(z_3.^2) + tau_3_max;
elseif Section.type == 3            % Square
    tau_3_max = ((3/2).*(T_3./A_3))./1000;
    tau_3 = -(tau_3_max./((r1_3/2).^2)).*((z_3./2).^2) + tau_3_max;
elseif Section.type == 4            % Rectangular
    tau_3_max = ((3/2).*(T_3./A_3))./1000;
    tau_3 = -(tau_3_max./((r1_3/2).^2)).*((z_3./2).^2) + tau_3_max;
elseif Section.type == 5            % Hollowed circular
    tau_3_max = (2.*(T_3./A_3))./1000;
    tau_3 = -(tau_3_max./(r1_3.^2)).*(z_3.^2) + tau_3_max;
elseif Section.type == 6            % Hollowed square
    tau_3_max = (T_3./(A_3 - (2.*r1_3.*t_3)))./1000;
    tau_3 = tau_3_max;
elseif Section.type == 7            % Hollowed rectangular
    tau_3_max = (T_3./(A_3-(2.*r2_3.*t_3)))./1000;
    tau_3 = tau_3_max;   
end

sigma_3_VM = ((sigma_3_NM.^2) + 3.*(tau_3.^2)).^0.5;

sigma_3_max_VM = max(max(abs(sigma_3_VM)));

sigma_3_VMmax = max(abs(sigma_3_VM));

AAAA_3 = [s_3' sigma_3_VMmax'];

toc

sigma_VMmax = [sigma_1_VMmax(1:end-1) sigma_2_VMmax(1:end-1) sigma_3_VMmax(1:end)];
Results = [Results_1(1:end-1,:); Results_3(1:end-1,:); Results_2];

figure(1)
plot(x_s_1,z1_1,'o', 'Linewidth',1.5);
grid on;
title('s(x)', 'fontsize',14);
xlabel('x[m]', 'fontsize',12);
ylabel('s(x)[m]', 'fontsize',12);

figure(2)
plot(x_s_3,z1_3,'o', 'Linewidth',1.5);
grid on;
title('s(x)', 'fontsize',14);
xlabel('x[m]', 'fontsize',12);
ylabel('s(x)[m]', 'fontsize',12);

figure(3)
plot(x_s_2,z1_2,'o', 'Linewidth',1.5);
grid on;
title('s(x)', 'fontsize',14);
xlabel('x[m]', 'fontsize',12);
ylabel('s(x)[m]', 'fontsize',12);

z1 = double(subs(y,X,x_s));
figure(4)
plot(x_s,z1,'o', 'Linewidth',1.5);
grid on;
title('s(x)', 'fontsize',14);
xlabel('x[m]', 'fontsize',12);
ylabel('s(x)[m]', 'fontsize',12);

% M = [M_1];
% s = [s_1];
% figure(10)
% plot(s,M,'Linewidth',1.5);
% grid on;
% title('Bending moment', 'fontsize',14);
% xlabel('s[m]', 'fontsize',12);
% ylabel('M[kNm]', 'fontsize',12);
% 
% M = [M_3];
% s = [s_3];
% figure(11)
% plot(s,M,'Linewidth',1.5);
% grid on;
% title('Bending moment', 'fontsize',14);
% xlabel('s[m]', 'fontsize',12);
% ylabel('M[kNm]', 'fontsize',12);

% M = [M_2];
% s = [s_2];
% figure(12)
% plot(s,M,'Linewidth',1.5);
% grid on;
% title('Bending moment', 'fontsize',14);
% xlabel('s[m]', 'fontsize',12);
% ylabel('M[kNm]', 'fontsize',12);

M = [M_1 M_3 M_2];
s = [s_1 s_1(8)+s_3 s_1(8)+s_2+s_3(37)];
figure(13)
plot(s,M,'Linewidth',1.5);
grid on;
title('Bending moment', 'fontsize',14);
xlabel('s[m]', 'fontsize',12);
ylabel('M[kNm]', 'fontsize',12);

N = [N_1 N_3 N_2];
s = [s_1 s_1(8)+s_3 s_1(8)+s_2+s_3(37)];
figure(14)
plot(s,N,'Linewidth',1.5);
grid on;
title('Axial force', 'fontsize',14);
xlabel('s[m]', 'fontsize',12);
ylabel('N[kNm]', 'fontsize',12);

T = [T_1 T_3 T_2];
s = [s_1 s_1(8)+s_3 s_1(8)+s_2+s_3(37)];
figure(15)
plot(s,T,'Linewidth',1.5);
grid on;
title('Shear force', 'fontsize',14);
xlabel('s[m]', 'fontsize',12);
ylabel('N[kNm]', 'fontsize',12);


% figure(1)
% plot(x_1_inter, double(subs(y_1,X_1,x_1_inter)),'Linewidth',1.5);
% grid on;
% title('Arch shape', 'fontsize',14);
% xlabel('x[m]', 'fontsize',12);
% ylabel('y(x)[m]', 'fontsize',12);
% 
% 
% figure(2)
% plot(x_3_inter, double(subs(y_3,X_3,x_3_inter)),'Linewidth',1.5);
% grid on;
% title('Arch shape', 'fontsize',14);
% xlabel('x[m]', 'fontsize',12);
% ylabel('y(x)[m]', 'fontsize',12);
% 
% 
% figure(3)
% plot(x_2_inter, double(subs(y_2,X_2,x_2_inter)),'Linewidth',1.5);
% grid on;
% title('Arch shape', 'fontsize',14);
% xlabel('x[m]', 'fontsize',12);
% ylabel('y(x)[m]', 'fontsize',12);

